########################################################################
# floppyFilesBrowseImage() -	throws up a file selection box for
#                               diskette image.
########################################################################
proc floppyFilesBrowseImage {win type} {
    global FloppyType
    global tcl_platform
    global genericExts
    global OSListFile

    #   Type names		Extension(s)	Mac File Type(s)
    #
    #---------------------------------------------------------

    if { $FloppyType == "generic" || [array names OSListFile -exact "exts"] == "" } {
    
	set types [list [list "Known formats"       [floppyExtsUC $genericExts]] \
		        [list "SVD internal format" ".svd .SVD"] \
			[list "All files"           "*"]]
    } else {
	set types [list [list "$FloppyType floppy formats" [floppyExtsUC $OSListFile(exts)]] \
		        [list "All Known formats"          [floppyExtsUC $genericExts]] \
			[list "SVD internal format"        ".svd .SVD"] \
	                [list "All files"		   "*"]]
    }

    unset -nocomplain filesDir imagesDir genericDir

    if { $tcl_platform(platform) == "windows" } {
	append outputDir "Windows-output-" $FloppyType
	append filesDir "Windows-files-" $FloppyType
	append imagesDir "Windows-images-" $FloppyType
	append genericDir "Windows-files-generic"
    } else {
	append outputDir "Unix-output-" $FloppyType
	append filesDir "Unix-files-" $FloppyType
	append imagesDir "Unix-images-" $FloppyType
	append genericDir "Unix-files-generic"
    }

    if { $type == "existing" } {
	if { [set dir [iniGetAttribute "Directories" $imagesDir]] == "" } {
	    if { [set dir [iniGetAttribute "Directories" $filesDir]] == "" } {
		set dir [iniGetAttribute "Directories" $genericDir]
	    }
	}
	set file [tk_getOpenFile -filetypes $types -parent $win \
		                 -initialdir $dir -title "Select image file"]
	if { $file != "" } {
	    iniSetAttribute "Directories" $imagesDir [file dirname $file]
	}
    } else {
	if { [set dir [iniGetAttribute "Directories" $outputDir]] == "" } {
	    if { [set dir [iniGetAttribute "Directories" $imagesDir]] == "" } {
		if { [set dir [iniGetAttribute "Directories" $filesDir]] == "" } {
		    set dir [iniGetAttribute "Directories" $genericDir]
		}
	    }
	}
	set file [tk_getSaveFile -filetypes $types -parent $win \
		                 -initialdir $dir -title "Select Upload target image file"]
	if { $file != "" } {
	    iniSetAttribute "Directories" $outputDir [file dirname $file]
	}
    }

    return $file
}

########################################################################
# floppyFilesBrowseFiles() -	throws up a file selection box for files
#                               that will be put on a diskette 
#                               (ie - not an image).
########################################################################

proc floppyFilesBrowseFiles {win} {
    global FloppyType
    global tcl_platform

    #   Type names		Extension(s)	Mac File Type(s)
    #
    #---------------------------------------------------------

    set types {
	{"All files"		*}
    }

    unset -nocomplain filesDir imagesDir genericDir

    if { $tcl_platform(platform) == "windows" } {
	append filesDir "Windows-files-" $FloppyType
	append imagesDir "Windows-images-" $FloppyType
	append genericDir "Windows-files-generic"
    } else {
	append filesDir "Unix-files-" $FloppyType
	append imagesDir "Unix-images-" $FloppyType
	append genericDir "Unix-files-generic"
    }

    if { [set dir [iniGetAttribute "Directories" $filesDir]] == "" } {
	if { [set dir [iniGetAttribute "Directories" $imagesDir]] == "" } {
	    set dir [iniGetAttribute "Directories" $genericDir]
	}
    }

    set file [tk_getOpenFile -filetypes $types -parent $win \
	                      -initialdir $dir -title "Select image file"]

    if { $file != "" } {
	iniSetAttribute "Directories" $filesDir [file dirname $file]
    }

    return $file
}

################################################################################
# the following code was taken from fileutil.tcl, which is a package distributed
# with version 2.6.1 of the ActiveState Dev Kit.  I adopted this code because
# the package it was in defined a ton of useless stuff (for this program anyway).
# If other things become important from that package, I'll get rid of this
# routine and load the package instead.  NOTE - only the name was changed.
################################################################################

########################################################################
# tempfile() -	generate a temporary file name suitable for writing to
#		the file name will be unique, writable and will be in the 
#		appropriate system specific temp directory
#		Code taken from http://mini.net/tcl/772 attributed to
#		Igor Volobouev and anon.
# Arguments:
#   prefix     - a prefix for the filename, p
# Results:
#   returns a file name
#########################################################################

proc tempfile {{prefix {}}} {
    global  tcl_platform
    switch $tcl_platform(platform) {
	unix {
	    set tmpdir /tmp;   # or even $::env(TMPDIR), at times.
	} macintosh {
	    set tmpdir $env(TRASH_FOLDER)  ;# a better place?
	} default {
	    set tmpdir [pwd]
	    catch {set tmpdir $env(TMP)}
	    catch {set tmpdir $env(TEMP)}
	}
    }

    set chars "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
    set nrand_chars 10
    set maxtries 10
    set access [list RDWR CREAT EXCL TRUNC]
    set permission 0600
    set channel ""
    set checked_dir_writable 0
    set mypid [pid]
    for {set i 0} {$i < $maxtries} {incr i} {
 	set newname $prefix
 	for {set j 0} {$j < $nrand_chars} {incr j} {
 	    append newname [string index $chars \
		    [expr {([clock clicks] ^ $mypid) % 62}]]
 	}
	set newname [file join $tmpdir $newname]
 	if {[file exists $newname]} {
 	    after 1
 	} else {
 	    if {[catch {open $newname $access $permission} channel]} {
 		if {!$checked_dir_writable} {
 		    set dirname [file dirname $newname]
 		    if {![file writable $dirname]} {
 			error "Directory $dirname is not writable"
 		    }
 		    set checked_dir_writable 1
 		}
 	    } else {
 		# Success
		close $channel
 		return $newname
 	    }
 	}
    }
    if {[string compare $channel ""]} {
 	return -code error "Failed to open a temporary file: $channel"
    } else {
 	return -code error "Failed to find an unused temporary file name"
    }
}
